﻿/*
VERSION:		2.4
2.4		copyObject() now returns the cloned object
2.3		Changed emptyObject() to handle arrays properly
2.2		used "function" prefix to enable local scoping

USAGE:
	#include "copyObject.as"
	copyObject( source_obj, destination_obj );
	... or
	var destination_obj = copyObject( source_obj );
	
WHAT IT'S FOR
	Copy the contents of one object into another,
	erasing the destination object's contents first.
	
WHAT IT HANDLES:
	Basic variables	(ie: string, number, boolean)
	Multi-dimensional Arrays
	Normal Objects
	BitmapData
	XMLNode
	
WHAT IT SKIPS:
	Functions
	Most Actionscript classes & components
	MovieClips
	
*/



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



function emptyObject( inputObject )
{
	if( getType(inputObject) === "array" )
	{// if:  array
		inputObject.splice( 0, inputObject.length );
	}// if:  array
	
	else
	
	{// if:  object
		for (var nam in inputObject )
			delete inputObject[nam];
	}// if:  object
}// emptyObject()



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



function getType( inputObject )
{
	var output = "";
	
	// unsupported objects to ignore
	if ( inputObject instanceof Function )
	{
		// this is a function
		output = "function";
	}
	else if ( inputObject instanceof MovieClip )
	{
		// this is a movieClip
		output = "movieClip";
	}
	
	// supported objects to handle
	else if ( inputObject instanceof Array )
	{
		// this is an array
		output = "array";
	}
	else if ( inputObject instanceof XMLNode )
	{
		// this is an object
		output = "xml";
	}
	else if ( inputObject instanceof flash.display.BitmapData )
	{
		// this is an object
		output = "bitmap";
	}
	else if ( inputObject instanceof Object )
	{
		// this is an object
		output = "object";
	}
	else
	{
		// this is a regular variable
		output = "variable";
	}
	return output;	// object, array, string, number, boolean
}// getType()



function copyObject( srcObj, destObj )
{
	if( !destObj )		var destObj = {}
	emptyObject( destObj );
	var srcReversed = {};
	for( var childName in srcObj )
		srcReversed[childName] = srcObj[childName];
	for( var childName in srcReversed )
	{
		var thisChild = srcReversed[childName];
		var childType = getType(thisChild);
		
		// handle variables
		if (childType === "variable")
		{
			destObj[childName] = thisChild;
		}
		
		// handle pictures
		if (childType === "bitmap")
		{
			// // create new object
			destObj[childName] = thisChild.clone();
		}
		
		// handle XML
		if (childType === "xml")
		{
			// // create new object
			destObj[childName] = thisChild.cloneNode(true);
		}
		
		// handle Arrays
		if (childType === "array")
		{
			// // create new array
			destObj[childName] = new Array();
			// // set dest, scan array
			copyObject( thisChild, destObj[childName] );
		}
		
		// handle Objects
		if (childType === "object")
		{
			// // create new object
			destObj[childName] = new Object();
			// // set dest, scan object
			copyObject( thisChild, destObj[childName] );
		}
			
	}// END:  for...in
	
	return destObj;
}// copyObject()



